﻿Public MustInherit Class Shape

    Protected _NumberOfTriangles As Integer
    Protected Friend _VerticesList As New List(Of VertexPositionNormalTexture)
    Public Property Size As Vector3

    Sub New(size As Vector3)
        Me.Size = size
    End Sub

    Public ReadOnly Property NumberOfTriangles As Integer
        Get
            Return Me._NumberOfTriangles
        End Get
    End Property

    Public MustOverride Sub CreateVectors()

    Public MustOverride Sub FillVerticesList()

    Public Overridable Sub CreateNormals()

    End Sub

    Public Delegate Function RotationDeleg(degrees As Single) As Matrix

    Public MustOverride Sub RotateVectors(o As Shape, deleg As RotationDeleg, degrees As Single)

    Public MustOverride Function GetBoundingBoxForObject(o As WorldObject) As BoundingBox

    Public Overridable Function GetBoundingSphereForObject(o As WorldObject) As BoundingSphere
        Return BoundingSphere.CreateFromBoundingBox(Me.GetBoundingBoxForObject(o))
    End Function

    Protected Sub RotateVectors(o As Shape, rotationAxis As Axis, degrees As Single)
        'rotate the vectors
        Select Case rotationAxis
            Case Axis.X
                Me.RotateVectors(o, AddressOf Matrix.CreateRotationX, degrees)
            Case Axis.Y
                Me.RotateVectors(o, AddressOf Matrix.CreateRotationY, degrees)
            Case Axis.Z
                Me.RotateVectors(o, AddressOf Matrix.CreateRotationZ, degrees)
        End Select
    End Sub

    Public MustOverride Sub Translate(translateMatrix As Matrix)

    Protected Sub CreateGeometry()
        Me.CreateVectors()
        Me.CreateNormals()
        Me.FillVerticesList()
    End Sub

    Friend Sub Draw(device As GraphicsDevice)
        'need to update vertext buffer
        Using buffer As New VertexBuffer(device, VertexPositionNormalTexture.VertexDeclaration, Me._VerticesList.Count, BufferUsage.WriteOnly)
            buffer.SetData(Me._VerticesList.ToArray)
            device.SetVertexBuffer(buffer)
        End Using
        device.DrawPrimitives(PrimitiveType.TriangleList, 0, Me.NumberOfTriangles)
    End Sub

End Class

Public Enum Axis
    X
    Y
    Z
End Enum
